<style>
.input-group 
{
	height: 46px;
}
.bg-c
{
	background: #E44F26;
	color: #fff;
	font-weight: bold;
}
.bg-c:hover
{
	color: #fff;
}

.select2-container--default .select2-selection--single {
    border: 0px solid #ced4da;
    border-radius: 0px !important;
    height: 32px;
}

.select2-container--default .select2-selection--single {
     background-color: #e44f26; 
    border: 0px solid #aaa;
    border-radius: 4px;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 29px;
    color: #fff;
    background: #e44f26;

}

.select2-container--default .select2-selection--single .select2-selection__arrow b {
    border-color: #fff transparent transparent transparent;
    border-style: solid;
    border-width: 5px 4px 0 4px;
    height: 0;
    left: 50%;
    margin-left: -4px;
    margin-top: -6px;
    position: absolute;
    top: 50%;
    width: 0;
}


.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 29px;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #fff;
    font-size: 18px;
    /* line-height: 28px; */
}

</style>


<div class="row">
	<div class="col-md-12 mb-3">
		<div class="site_heading">
			<h3>Carpet Calculator</h3>
		</div>
	</div>
	<div class="col-md-12 p-3 pb-0 bg-light mb-0">
		<div class="row">



			<div class="col-md-12 px-4 p-2">
				<div class="row">


					<div class="col-4 mb-3">
						<label class="form-label fs-4">Width <span class="fs-4" id="b_livem2"> </span></label>
						<div class="input-group mb-3">
						  <input type="tel"  id="b_value" class="form-control" oninput="validate(this)" placeholder="" >
						  <span class="input-group-text  bg-c " id="basic-addon2">
						  	<select class="form-select" id="b_select">
						  		<option value="foot" >ft</option>
						  		<option value="inch">Inch</option>
						  		<option value="mm">mm</option>
						  		<option value="cm">cm</option>
						  		<option value="m" selected>m</option>
						  	</select>
						  </span>
						</div>
					</div>

					<div class="col-1 pt-5 text-center">
						<span class="mt-2 d-block">X</span>
					</div>

					<div class="col-4 mb-3">
						<label class="form-label fs-4">Length <span class="fs-4" id="l_livem2"> </span></label>
						<div class="input-group mb-3">
						  <input type="tel" id="l_value" value="" class="form-control" oninput="validate(this)" placeholder="" >
						  <span class="input-group-text  bg-c " id="basic-addon2">
						  	<select class="form-select " id="l_select">
						  		<option value="foot" >ft</option>
						  		<option value="inch">Inch</option>
						  		<option value="mm">mm</option>
						  		<option value="cm">cm</option>
						  		<option value="m" selected>m</option>
						  	</select>
						  </span>
						</div>
					</div>  
					<div class="col-3 mb-3">
						<label class="form-label fs-4">Actual Area (m<sup>2</sup>)</label>
						<div class="input-group mb-3">
						  <input type="tel" id="result" style="color:green; font-weight: bold; font-size: 22px;" oninput="validate(this)" class="form-control bg-white" disabled >
						  
						</div>

						
						
					</div>

				</div>
				<div class="row mb-3">
					<div class="col-md-3 mb-3">
						<label class="form-label">Price /m<sup>2</sup><sup class="text-danger ">*</sup></label>
						<input type="tel" value="" class="form-control rounded-0"  oninput="validate(this)" id="custome_price">
					</div>
					<div class="col-md-6">
						
					</div>
					
					<div class="col-md-3 mb-3 pt-4">
						<button id='calculator' class="btn float-end bg-c btn-lg rounded-0">CALCULATE</button>
					</div>
				</div>

			
				<div class="row">
					<div class="col-md-12 ">
						<span class="d-block 2_5mcarpet"></span>
						<span class="d-block 4mcarpet"></span>
						<span class="d-block 5mcarpet"></span>
						<span class="d-block mb-2 fs-5 total_price"></span>
					</div>
				</div>


			</div>


			
		</div>
	</div>
</div>




<script>

var validate = function(e) {
  var t = e.value;
  e.value = (t.indexOf(".") >= 0) ? (t.substr(0, t.indexOf(".")) + t.substr(t.indexOf("."), 3)) : t;
}

//  1ft = 0.092903 m2;

// b_livem2


$('#b_value').keyup(function(){
	bmatrix();
});

$('#b_select').change(function(){
	bmatrix();
});




$('#l_value').keyup(function(){
	lmatrix();
});
$('#l_select').change(function(){
	lmatrix();
});

function  bmatrix()
{
	const w_val = $('#b_value').val();
	const selectVal = $('#b_select').val();
	if(selectVal == 'inch')
	{
		const inch1 = 0.0254;
		$('#b_livem2').html(parseFloat(w_val * inch1).toFixed(2) + ' m');
	}else if(selectVal == 'mm')
	{
		const mm1 = 0.001;
		$('#b_livem2').html(parseFloat(w_val * mm1).toFixed(2) + ' m');
	}else if(selectVal == 'cm')
	{
		const cm1 = 0.01;
		$('#b_livem2').html(parseFloat(w_val * cm1).toFixed(2) + ' m');
	}else if(selectVal == 'm')
	{
		const m1 = 1;
		$('#b_livem2').html(parseFloat(w_val * m1).toFixed(2) + ' m');
	}else if(selectVal == 'foot')
	{
		const ft1 = 0.3048;
		$('#b_livem2').html(parseFloat(w_val * ft1).toFixed(2) + ' m');
	}
}

function  lmatrix()
{
	const l_val = $('#l_value').val();

	const selectVal = $('#l_select').val();

	if(selectVal == 'inch')
	{
		const inch1 = 0.0254;
		$('#l_livem2').html(parseFloat(l_val * inch1).toFixed(2) + ' m');
	}else if(selectVal == 'mm')
	{
		const mm1 = 0.001;
		$('#l_livem2').html(parseFloat(l_val * mm1).toFixed(2) + ' m');
	}else if(selectVal == 'cm')
	{
		const cm1 = 0.01;
		$('#l_livem2').html(parseFloat(l_val * cm1).toFixed(2) + ' m');
	}else if(selectVal == 'm')
	{
		const m1 = 1;
		$('#l_livem2').html(parseFloat(l_val * m1).toFixed(2) + ' m');
	}else if(selectVal == 'foot')
	{
		const ft1 = 0.3048;
		$('#l_livem2').html(parseFloat(l_val * ft1).toFixed(2) + ' m');
	}
}







$(document).ready(function(){

	$('#calculator').click(function(){

		console.clear();

		const lvalue = $('#l_value').val();
		const lselect = $('#l_select').val();
		const bvalue = $('#b_value').val();
		const bselect = $('#b_select').val();


		const price2_5_m = $('#2_5m_custome_price').val();
		const price4_m = $('#4m_custome_price').val();
		const price5_m = $('#5m_custome_price').val();

		const lengthVal =  convertBase(lselect, lvalue).toFixed(2);


		const widthVal =  convertBase(bselect, bvalue).toFixed(2);
		const area = lengthVal*widthVal;

		const priceVal = $('#custome_price').val();


		if(area)
		{
			$('#result').val(parseFloat(area).toFixed(2));

			$('.2_5mcarpet').html('');
			$('.4mcarpet').html('');
			$('.5mcarpet').html('');
			$('.total_price').html('');

			checkMatch(widthVal, lengthVal, priceVal);
			


		} // CLOSE IF

		
	});




	// Check Proper Devide Value





	const checkMatch = (widthVal, lengthVal, priceVal) => {

		// Check 2.5w Matched

			let w2_5check;
			const w2_5div = widthVal/2.5;
			(parseInt(w2_5div)*2.5 == widthVal) ?  w2_5check = true : w2_5check = false;


			// Check 4w Matched

			let w4check;
			const w4div = widthVal/4;
			(parseInt(w4div)*4 == widthVal) ?  w4check = true : w4check = false;


			// Check 5w Matched

			let w5check;
			const w5div = widthVal/5;
			(parseInt(w5div)*5 == widthVal) ?  w5check = true : w5check = false;

			// if(w4check === true){

			// 	$('.4mcarpet').html('4m Carpet = ' + w4div + ' * '+ lengthVal);

			// }else 
			if(w5check === true)
			{
				// console.log('5w is Perfect');	
				// 2_5mcarpet

				$('.5mcarpet').html('5m Carpet = ' + w5div + ' * '+ lengthVal);

				$('.total_price').html('Order Area & Price = £'+ (w5div*lengthVal*priceVal*5));

			
			}else
			{
				checkQuantity(widthVal, lengthVal, priceVal);
			}

	}






	const checkQuantity = (widthVal, lengthVal, priceVal) => {

		console.log(priceVal);

		let devision5m;
		let devision4m;
		let devision2_5m;
		let total_price = 0;

		let letdev4m = parseInt(widthVal/4);
		let letAvaliableWidth = widthVal - letdev4m*4;

		let letdev2_5m = parseInt(letAvaliableWidth/2.5);
		let letAvaliableWidthon2M = letAvaliableWidth - letdev2_5m*2.5;

		if(letdev4m*4 + letdev2_5m*2.5 == widthVal && widthVal > 2.5 && widthVal > 4 )
		{
			devision2_5m = letdev2_5m;
			devision4m = letdev4m;
		}else
		{
			devision5m = widthVal/5;
			devision5m = parseInt(devision5m);
			let availableWidth = widthVal - devision5m*5;

			if(availableWidth <= 2.5)
			{
				 devision2_5m = 1;
			}else if(availableWidth > 2.5 && availableWidth <= 4)
			{
				 devision4m = 1;
			}else if(availableWidth > 4 && availableWidth < 5)
			{
				devision5m = devision5m + 1;
			}

		}

		
		(devision2_5m) ? console.log('2.5M Carpet = ' + devision2_5m) : '' ;
		(devision4m) ? console.log('4M Carpet = ' + devision4m) : '' ;
		(devision5m) ? console.log('5M Carpet = ' + devision5m) : '' ;

		(devision2_5m) ? $('.2_5mcarpet').html('2.5m Carpet = ' + devision2_5m + ' * '+ lengthVal) : '' ;
		(devision4m) ? $('.4mcarpet').html('4m Carpet = ' + devision4m + ' * '+ lengthVal) : '' ;
		(devision5m) ? $('.5mcarpet').html('5m Carpet = ' + devision5m + ' * '+ lengthVal) : '' ;

		if(devision2_5m)
		{
			total_price = (devision2_5m*lengthVal*priceVal*2.5) + total_price;
			// console.log(devision2_5m*lengthVal*priceVal);
		}

		if(devision4m)
		{
			total_price = (devision4m*lengthVal*priceVal*4) + total_price;
			// console.log(devision4m*lengthVal*priceVal);
		}

		if(devision5m)
		{
			total_price = (devision5m*lengthVal*priceVal*5) + total_price;
			// console.log(devision5m*lengthVal*priceVal);
		}

		// console.log(total_price);

		$('.total_price').html('Total Price = £'+ total_price);

	} 



// if(availableWidthon4m > 2.5 && availableWidthon4m <= 4)
		// {	

		// 	console.log('4m carpet lOOP');
		// 	devision4m = availableWidthon4m/4;
		// 	devision4m = parseInt(devision4m);
		// 	let availableWidthon2_5m = availableWidthon4m - (devision4m*4);
		// 	console.log('4M Carpet = ' + devision4m);

		// 	if(availableWidthon4m <= 2.5)
		// 	{
		// 		devision2_5m = 1;
		// 	}else
		// 	{
		// 		devision2_5m = availableWidthon2_5m/2.5;
		// 		devision2_5m = parseInt(devision2_5m);
				
		// 	}
		// 	console.log('2.5M Carpet = ' + devision2_5m);

		// }else
		// {
		// 	devision2_5m = 1;
		// 	console.log('2.5M Carpet = ' + devision2_5m);
		// }





	function convertBase(selectVal, value)
	{
		if(selectVal == 'inch')
		{
			return value * 0.0254;
		}else if(selectVal == 'mm')
		{
			return value * 0.001;
		}else if(selectVal == 'cm')
		{
			return value * 0.01;
		}else if(selectVal == 'm')
		{
			return value * 1;
		}else if(selectVal == 'foot')
		{
			return value * 0.3048;
		}
	}

});


</script>



