<?php 
$uri = current_url(true); 
$sub_title = ucwords(str_replace('-',' ', $uri->getSegment(2)));

?>

<script src="https://cdn.ckeditor.com/4.19.0/standard/ckeditor.js"></script>


<form action="<?= current_url().'?action=create'; ?>" method="post">


<div class="row">
	<div class="col-md-12">
		<ul class="nav nav-tabs">
		  <li class="nav-item">
		    <a class="nav-link rounded-0 active" aria-current="page" href="#">Basic</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  href="#">Features</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0" href="#">Dimensions</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0" href="#">Technical Information</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0" href="#">Color</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  >Images</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  >Variant</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0" >Price</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0" >SEO</a>
		  </li>
		  
		  <li class="nav-item">
		    <a class="nav-link rounded-0" >Accessories</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0" >Other</a>
		  </li>
		  
		  <li class="nav-item">
		    <a class="nav-link rounded-0" >Status</a>
		  </li>
		</ul>
	</div>
</div>

<div class="row bg-light p-3">
	<div class="col-md-12 mb-3">
		<h3 class="fs-5">Add Product</h3>
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Title<sup class="text-danger fw-bold">*</sup></label>
		<input type="text" class="form-control rounded-0" name="title" required>
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Sub Title<sup class="text-danger fw-bold">*</sup></label>
		<input type="text" class="form-control rounded-0" name="sub_title" required>
	</div>
	
	
	<div class="col-md-6 mb-3">
		<label class="form-label">Category</label>
		<select required class="form-select rounded-0" id="cat_select">
			<option value="">Select</option>
			<?php 
			
			// getCategoryOptions();
			foreach($cat_list as $c){

				$subCategory = getCwfCategoryListByID($c->cwf_cat_id);
				if($subCategory)
				{
					echo '<option value="'.$c->cwf_cat_id.'">'.$c->cwf_cat_name.'</option>';
				} 
			} 
			?>
		</select>
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Sub Category</label>
		<div id="sub_category">
			<select name="sub_category" required class="form-select rounded-0">
			
			</select>
		</div>
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Attribute Category</label>
		<select name="attr_category[]"   multiple class="form-select rounded-0">
			<?php 
			foreach($attr_cat_list as $ac){
				echo '<option value="'.$ac->cwf_attr_cat_id.'">'.$ac->cwf_attr_cat_name.'</option>';
			} 
			?>
		</select>
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Collections</label>
		<select name="collections[]"  multiple class="form-select rounded-0">
			<?php 
			foreach($coll_list as $cl){
				echo '<option value="'.$cl->cwf_coll_id.'">'.$cl->cwf_coll_name.'</option>';
			} 
			?>
		</select>
	</div>
	
	
	
	<div class="col-md-12 mb-3">
		<label class="form-label">Shades</label>
		<select name="shades[]"   multiple class="form-select rounded-0">
			<?php 
			foreach($shades_list as $sl){
				echo '<option value="'.$sl->cwfc_id.'">'.$sl->cwfc_name.'</option>';
			} 
			?>
		</select>
	</div>
	

	<div class="col-md-12 mb-3">
		<label class="form-label">Description</label>
		<textarea name="description"  id="editor" class="form-control rounded-0" ></textarea>
	</div>
    <div class="col-md-6 mb-3 pt-2">
		<label class="form-label">Tags:</label>
		<div class="">

			<?php foreach($tag_list as $tl){ ?>

				<span class="me-2">
				  	<input class="form-check-input"  value="<?= $tl->cwfpt_id; ?>" name="product_tag" type="radio" >
					<label class="form-check-label" >
					    <?= $tl->cwfpt_name; ?>
					</label>
				</span>

			<?php } ?>


		  
		</div>

	</div>
	
	<div class="col-md-6 mb-3">
		<label class="form-label">CF SKU code</label>
		<input type="text" class="form-control" disabled >
	</div>

	<div class="col-md-6 mb-3">
		<label class="form-label">Supplier Name</label>
		<select name="supplier" required class="form-select rounded-0">
			<option value="">Select</option>
			<?php 
			foreach($supplier_list as $sl){
				echo '<option value="'.$sl->ac_id.'">'.$sl->ac_fname.' '.$sl->ac_lname.' ('.$sl->sup_company.')</option>';
			} 
			?>
		</select>
	</div>

	<div class="col-md-6 mb-3">
		<label class="form-label">Supplier SKU code</label>
		<input type="text" name="supplier_sku_code" class="form-control" >
	</div>
	
	
	<div class="col-md-12">
		<button type="submit" class="btn btn-success rounded-0 btn-sm">Save</button>
	</div>
</div>
</form>


<script>
    CKEDITOR.replace( 'editor' );
</script>



<script type="text/javascript">
	$(document).ready(function(){
		$('#cat_select').change(function(){
			const catId = $(this).val();

			$.ajax({
				url:'<?= site_url('ajax/get/sub-category?cat_id=') ?>'+catId,
				method:'GET',
				success:function(data)
				{
					$('#sub_category').html(data);
				},error:function()
				{
					console.log('ajax error');
				}
			});

		});
	});
</script>