<?php 
$uri = current_url(true); 
$sub_title = ucwords(str_replace('-',' ', $uri->getSegment(2)));

?>

<script src="https://cdn.ckeditor.com/4.19.0/standard/ckeditor.js"></script>


<style type="text/css">
	.colorCheck
	{
		width: 23px;
		height: 23px;
	}
	.fs-6
	{
		font-size: 14px !important;
	}
	
	.hidden {
	display: none !important;
}
</style>



<div class="row">
	<div class="col-md-12">
		<ul class="nav nav-tabs">
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  href="<?= current_url().'?action=edit&token='.getProductHash($_GET['product_id']).'&product_id='.$_GET['product_id']; ?>">Basic</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  href="<?= current_url().'?action=edit&section=features&product_id='.$_GET['product_id']; ?>">Features</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  href="<?= current_url().'?action=edit&section=dimensions&product_id='.$_GET['product_id']; ?>">Dimensions</a>
		  </li>
		  
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=technical-information&product_id='.$_GET['product_id']; ?>">Technical Information</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 active"  href="<?= current_url().'?action=edit&section=color&product_id='.$_GET['product_id']; ?>">Color</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=images&product_id='.$_GET['product_id']; ?>">Images</a>
		  </li>
		  <li class="nav-item">
		  	<a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=filters&product_id='.$_GET['product_id']; ?>">Filters</a>
		  </li>
		  <li class="nav-item">
		  	<a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=sku&product_id='.$_GET['product_id']; ?>">SKU</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=variant&product_id='.$_GET['product_id']; ?>">Variant</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=price&product_id='.$_GET['product_id']; ?>">Price</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=seo&product_id='.$_GET['product_id']; ?>">SEO</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  href="<?= current_url().'?action=edit&section=accessories&product_id='.$_GET['product_id']; ?>">Accessories</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  href="<?= current_url().'?action=edit&section=other&product_id='.$_GET['product_id']; ?>">Other</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=status&product_id='.$_GET['product_id']; ?>">Status</a>
		  </li>
		</ul>
	</div>
</div>

<div class="row bg-light p-3">
	<div class="col-md-12 mb-3">
		<h3 class="fs-5 float-start">Manage Color</h3>

		<button type="button" class="btn btn-primary rounded-0  float-end" data-bs-toggle="modal" data-bs-target="#exampleModal">Add</button>

	</div>

	<table class="table table-bordered">
		<thead>
			<tr>
				<th>#</th>
				<th>Title</th>
				<th>Color/image</th>
				<th width="100px">Short</th>
				<th width="70px">Status</th>
				<th width="120px">Action</th>
				<th width="40px">Logs</th>
			</tr>
		</thead>
		<tbody>
			
			<?php $i=1; foreach($list as $l){ ?>

			<tr>
				<td><?= $i; ?> </td>
				<td><?= $l->cwfc_name ?></td>
				<td class="d-flex align-items-center"><div style="background: <?= $l->cwfc_code; ?>; width:23px; height:23px" class="me-2">
					<?php if(!empty($l->cwfc_image)){ ?>
		        			<img src="<?= site_url('uploads/color-images/'.$l->cwfc_image); ?>" width="100%">
		        		<?php } ?>
				</div> <?php echo (!empty($l->cwfc_code)) ? $l->cwfc_code : '' ?></td>
				
				<td>
					<input type="text" min="0" value="<?= $l->cwfpc_order; ?>" class="rounded-0 form-control order_input" id='<?= $l->cwfpc_hash; ?>' data-item-id='<?= $l->cwfpc_hash; ?>' >
					
				</td>
				<td class="pt-3">
					<?php 
									if($l->cwfpc_status == 'A')
									{
										echo '<span class="bg-success py-1 px-2 text-white rounded">Active</span>';
									}elseif($l->cwfpc_status == 'D')
									{
										echo '<span class="bg-danger py-1 px-2 text-white rounded">Deactive</span>';
									}
									 ?>
				</td>
				<td>
					<a href="<?= current_url().'?action=editconf&section=color&product_id='.$_GET['product_id'].'&token='.$l->cwfpc_hash; ?>" class="btn btn-sm btn-warning"><i class="bi bi-pencil-square"></i></a>
					<a href="<?= site_url('admin/delete?action='.$_GET['section'].'&token='.$l->cwfpc_hash.'&rid='.$_GET['product_id']); ?>" class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></a>
				
				<?php if(!empty($l->cwfpc_color_specific_details)){ ?>

						<a href="#" class="btn btn-sm btn-warning addSpecificInfo" data-color-hash="<?= $l->cwfpc_hash; ?>" data-bs-toggle="modal" data-bs-target="#specificModal">
						S
						</a>
					<?php }else{ ?>
						<a href="#" class="btn btn-sm btn-secondary addSpecificInfo" data-color-hash="<?= $l->cwfpc_hash; ?>" data-bs-toggle="modal" data-bs-target="#specificModal">
						S
						</a>
					<?php } ?>

				
				</td>
				<td>
					<?php logs($l->cwfpc_created_at, $l->cwfpc_created_id, $l->cwfpc_updated_at, $l->cwfpc_updated_id); ?>
				</td>
			</tr>

			<?php $i++; } ?>

  
		</tbody>
	</table>


</div>


<script>
    CKEDITOR.replace( 'editor' );
</script>





<!-- Color specificModal mODLE -->

<!-- Modal -->
<div class="modal fade" id="specificModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Color Specific information</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>


      
	      <div class="modal-body">
	      	<div class="row" id="colorSpecific">

	      	</div>
	        
	      </div>

    </div>
  </div>
</div>






<script type="text/javascript">
	

$('.addSpecificInfo').click(function(){

	const colorHash = $(this).data('color-hash');
	$.ajax({
		url:'<?= site_url('color/getSpecificInfo?token=') ?>'+colorHash,
		method:'GET',
		success:function(data)
		{
			$('#colorSpecific').html(data);
		},error:function()
		{
			console.log('ajax')
		}
	})

});

</script>















<!--  -->


<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add Color</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <form action="<?= current_url().'?action=edit&section=color&product_id='.$_GET['product_id'].'&type=add' ?>" method="post">
	      <div class="modal-body">
	          <div class="row">


	      		<div class="col-md-4 py-3">
	      			<input type="text" placeholder="Search Color" class="form-control" data-search />
	      		</div>
	      		
	      	</div>
	        <div class="row items">

	        	<?php foreach($color_list as $cl){ ?>
		        	<div class="col-3 d-flex mb-3 align-items-center"  data-filter-item data-filter-name="<?= strtolower($cl->cwfc_name); ?>" class="listColorids">
		        		<input type="checkbox" id="color" name="color[]" class="me-2 colorCheck rounded-0" value="<?= $cl->cwfc_id; ?>">
		        		<div style="background: <?= $cl->cwfc_code; ?>; width:23px; height:23px" class="me-2" >
		        			<?php if(!empty($cl->cwfc_image)){ ?>
		        			<img src="<?= site_url('uploads/color-images/'.$cl->cwfc_image); ?>" width="100%">
		        		<?php } ?>
		        		</div>
		        		<span class="fs-6"><?= $cl->cwfc_name; ?></span>
		        	</div>
	        	<?php } ?>

	        </div>
	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
	        <button type="submit" class="btn btn-primary" id="submit_form">Add</button>
	      </div>
      </form>

    </div>
  </div>
</div>

<script type="text/javascript">
	
$('[data-search]').on('keyup', function() {
	var searchVal = $(this).val();
	var filterItems = $('[data-filter-item]');

	if ( searchVal != '' ) {
		filterItems.addClass('hidden');
		$('[data-filter-item][data-filter-name*="' + searchVal.toLowerCase() + '"]').removeClass('hidden');
	} else {
		filterItems.removeClass('hidden');
	}
});
</script>

<script>
	
$(document).ready(function(){
	$('.order_input').keyup(function(){
		const token = $(this).data('item-id');
		var order_input = $(this).val();


		if(order_input <  1)
		{
			order_input = 1;
		}else
		{
			$.ajax({
				url:'<?= base_url('ajax/update/ordering?token=') ?>'+token+'&order='+order_input+'&action=product_color',
				type:'GET',
				success:function(data)
				{
					const resOBJ = JSON.parse(data);
					console.warn(resOBJ);
				},
				error:function()
				{
					alert('Ajax error');
				}
			});
		}

	});	
});

</script>