<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<!-- <meta name="viewport" content="width=device-width, initial-scale=1"> -->
	<title>Quotation</title>
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style type="text/css">
	
.print-header
{
	background: #373737;
}
.clear-float
{
	clear: both;
}
.border-bottoms
{
	border-bottom: 1px solid #bd9e8b;
}
.border-right
{
	border-right: 2px solid #c16d2f;
}
.border-shadow
{
	border: 1px solid #c0aea2;
}

.ctr
{
	background: #fbfbfb;
	margin-bottom: 10px;
	border-bottom: 10px solid #fff;
}

p
{
	font-size: 14px;
	margin-bottom: 0px;
}
textarea, span
{
	font-size: 13px;
	margin-bottom: 0px;
}
.w-td
{
	min-width: 180px;
	display: inline-block;
}

.green-bg
{
	background: #538234;
	width: 100%;
	text-align: center;
	font-size: 30px;
	font-weight: 600;
	color: #fff;
	padding: 40px 0px;
}

.red-bg
{
	background: #538234;
	width: 100%;
	text-align: center;
	font-size: 30px;
	font-weight: 600;
	color: #fff;
	padding: 40px 0px;
}

td, th
{
	font-size: 13px;
}

</style>

</head>
<body>

<?php 

$custData = getAdminDataByID($details->o_cust_id);
										

 ?>

<section class="bg-dark" style="min-height: 100vh;">
	<div class="container">
		<div class="row justify-content-evenly">
			<div class="col-md-7 bg-white px-0" style="min-height: 100vh;">
				
				<header class="print-header py-5 px-4">
					<h1 class="float-start " style="color: #c49f6b;">Quotation</h1>
					<img src="<?= site_url('front/img/print-logo.png') ?>" class="float-end" width="200px">
					<div class="clear-float"></div>
				</header>

				<div class="text-center py-4 border-bottoms">
					<p>24, Nottingham Road, Loughborough, Leicestershire LE11 1EU | Tel: 01509 267 413</p>
				</div>

				<div class="py-3 px-4 border-bottoms">
					<div class="row">
						<div class="col-8 py-4 pt-4">
							<div class="row mt-1">
								<div class="col-6 pe-0">
									<span class="border-shadow p-3 py-2 d-block p-4 " >Invoice To: <?=  $custData->ac_fname.' '.$custData->ac_mname.' '.$custData->ac_lname; ?> <br> <?= $custData->ac_street_address; ?> <br>  <?= $custData->ac_zip; ?></span>
								</div>
								<div class="col-6 ps-1 pt-0">
									<span class="border-shadow px-1 py-1 mt-0 d-block">Quote Date: <?= date('d/m/Y', strtotime($details->o_created_at)) ?></span>
									<span class="border-shadow px-1 py-1 my-1 d-block">Valid Until: N.I.</span>
									<span class="border-shadow px-1 py-1  d-block">Quote Number: <?= $details->o_id; ?></span>
								</div>
							</div>
						</div>
						<div class="col-4">
						        
						    <?php if($details->o_status == 'PD'){ ?>
						    <div class="red-bg">
								PAID
							</div>
						    <?php }else{ ?>
							<div class="green-bg">
								ACCEPT QUOTE
							</div>
							<?php } ?>
						</div>
					</div>
				</div>


				<div class="py-3 px-4 ">
					<table class="table table-borderless">
						<thead>
							<tr>
								<th width="300">Description</th>
								<th>Rate/Price m<sup>2</sup></th>
								<th>Qty</th>
								<th>Line Total</th>
							</tr>
						</thead>
						<tbody>

							<?php foreach($list as $ls){ ?>

							<tr class="ctr">
								<td class="border-right"><?= $ls->pro_title ?> <br>
									<!-- Size: (2m length) <br>
									Colour Code: QSVINCP40035 -->
									<b>Colour Code:</b> <?= $ls->oci_sku_code ?>	
								</td>
								<td  class="border-right"><?= currency_filter($ls->oci_prod_price) ?></td>
								<td  class="border-right"><?= $ls->oci_prod_qty ?></td>
								<td><?= currency_filter($ls->oci_prod_price*$ls->oci_prod_qty) ?></td>
							</tr>

							<?php } ?>


							<!-- <tr class="ctr">
								<td class="border-right">
									Heavenly Twist - MID RANGE LUXURY CARPET <br>
									Designated Fitting Area: Bedroom 1 <br>
									Colour: 901 D. Grey <br>
									Pile Content: 100% PP <br>
									Construction: 2 Ply Yarn <br>
									Backing: Actionback <br>
									Width: 4m Only <br>
									Suitability: Heavy Domestic <br>
									Warranty: 15 Year Wear <br>
									Benefits: Bleach Cleanable Stainbloc Technology
								</td>
								<td  class="border-right"></td>
								<td  class="border-right"></td>
								<td></td>
							</tr> -->
							<tr class="ctr">
								<td >
									
								</td>
								<td colspan="2">
									<span class="border-shadow p-3 py-1 mt-2 float-end" >Subtotal</span>
									<div class="clear-float"></div>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >Discount Amount %</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >Discounted Sub Total</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >VAT</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >Amount To Pay</span>
								</td>
								<td>
									<span class="border-shadow p-3 py-1 mt-2 d-block" ><?= currency_filter($details->o_total) ?></span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >N.I.</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >N.I.</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >N.I.</span>
									<span class="border-shadow p-3 py-1 mt-2 d-block" >£ N.I.</span>
								</td>
							</tr>
							
						</tbody>
					</table>
				</div>

			</div>
		</div>
	</div>
</section>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/js/bootstrap.bundle.min.js" ></script>
</body>
</html>