<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.


$routes->get('/', 'Home::index');
$routes->get('/logout', 'Home::logout');

$routes->get('resize/image', 'Home::resizeImage');

$routes->group('print', function($routes){
	$routes->get('quotation', 'Home::quotation');
	$routes->get('accept-quotation', 'Home::acceptQuotation');
	$routes->get('view-invoice', 'Home::viewInvoice');
});

$routes->group('coupons', function($routes){
	$routes->post('/', 'Ecom/Coupons::index');
	$routes->get('/', 'Ecom/Coupons::index_get');
});

// USERS ROUTES

// $routes->group('user', function($routes){
// 	$routes->get('login', 'User::index');
// 	$routes->get('create', 'User::create');

// 	$routes->post('login', 'User::loginConf');
// 	$routes->post('create', 'User::createConf');

// 	$routes->get('logout', 'User::logout');

// 	$routes->get('dashboard', 'UserDashboard::index', ['filter' => 'userAuthGuard']);

// 	$routes->post('profile/complete', 'UserDashboard::completeProfile', ['filter' => 'userAuthGuard']);

//     $routes->get('order/details', 'UserDashboard::orderDetails', ['filter' => 'userAuthGuard']);
// });

// USERS ROUTES

$routes->group('user', function($routes){
	$routes->get('login', 'User::index');
	$routes->get('create', 'User::create');

    $routes->get('forgot-password', 'Home::forgot_password');
	$routes->post('forgot-password', 'Home::forgot_password_post');

	$routes->get('verify-forgot-otp', 'Home::verify_forgot_otp');
	$routes->post('verify-forgot-otp', 'Home::verify_forgot_otp_post');


	
	$routes->post('forgot/change-password', 'Home::forgot_change_password');


	$routes->post('login', 'User::loginConf');
	$routes->post('create', 'User::createConf');

	$routes->get('logout', 'User::logout');

	$routes->get('dashboard', 'UserDashboard::index', ['filter' => 'userAuthGuard']);
	$routes->get('quotation-history', 'UserDashboard::quotation_history', ['filter' => 'userAuthGuard']);
	

	$routes->get('profile', 'UserDashboard::completeProfileView', ['filter' => 'userAuthGuard']);

	$routes->post('profile', 'UserDashboard::completeProfile', ['filter' => 'userAuthGuard']);

    $routes->get('order/details', 'UserDashboard::orderDetails', ['filter' => 'userAuthGuard']);



    $routes->get('change-password', 'UserDashboard::changePassword', ['filter' => 'userAuthGuard']);
    $routes->post('change-password', 'UserDashboard::changePasswordPost', ['filter' => 'userAuthGuard']);



});



// Home PAGE

$routes->get('search', 'ProductDetailsController::search');
$routes->get('ajax/search', 'ProductDetailsController::ajaxSearch');
$routes->get('ajax/search/pager', 'ProductDetailsController::ajaxSearchwithPager');

$routes->get('/product/(:any)', 'ProductDetailsController::index/$1');

$routes->get('/category/(:any)', 'CategoryController::index/$1');

$routes->get('/ajax/category/pager/(:any)/(:any)', 'CategoryController::ajaxIndexwithPagination/$1/$2');
$routes->get('/ajax/category/(:any)/(:any)', 'CategoryController::ajaxIndex/$1/$2');

$routes->get('/ajax/image-slider/filter', 'ProductDetailsController::imageSliderFilter');



// Filter 

$routes->get('/set/filter', 'Home::setFilterColor');
$routes->get('/unset/filter', 'Home::unsetFilterColor');


$routes->get('/set/filter/option', 'Home::setFilterOptions');
$routes->get('/unset/filter/option', 'Home::unsetFilterOptions');



// Cart Routes

$routes->group('cart', function($routes){
	$routes->get('/', 'Ecom/Cart::index', ['filter' => 'userAuthGuard']);
	$routes->get('add', 'Ecom/Cart::add', ['filter' => 'userAuthGuard']);
	
	$routes->get('add/accessories', 'Ecom/Cart::add_accessories', ['filter' => 'userAuthGuard']);
	$routes->get('add/accessories_product', 'Ecom/Cart::add_accessories_product', ['filter' => 'userAuthGuard']);
	
	
	
	$routes->post('add', 'Ecom/Cart::add_post', ['filter' => 'userAuthGuard']);
	$routes->get('remove', 'Ecom/Cart::remove', ['filter' => 'userAuthGuard']);
	$routes->get('update', 'Ecom/Cart::updateQty', ['filter' => 'userAuthGuard']);
	
	
	$routes->get('complete', 'Ecom/Cart::complete');

	$routes->get('success', 'Ecom/Cart::success');
});




$routes->post('newsletter', 'Admin/NewsletterController::addNewsLetter');


$routes->get('contact', 'Home::contact');
$routes->post('contact', 'Home::contactSubmit');




###############################	ADMIN ROUTES #############################



$routes->get('color/getSpecificInfo', 'Cwf/Ajax::getColorSpecificInfo', ['filter' => 'authGuard']);
$routes->post('color/getSpecificInfo', 'Cwf/Ajax::getColorSpecificInfoPOST', ['filter' => 'authGuard']);


$routes->group('admin', function($routes){

	$routes->get('/', 'Admin/AdminController::redirect_login');
	$routes->get('login', 'Admin/AdminController::index');
	$routes->post('login', 'Admin/AdminController::auth');
	

	$routes->get('dashboard', 'Admin/AdminDashboard::index', ['filter' => 'authGuard']);

	// Mega Menu & Sub Menu
	$routes->group('mega-menu', function($routes){
		$routes->get('/', 'Admin/MegamenuController::index', ['filter' => 'authGuard']);
		$routes->get('add', 'Admin/MegamenuController::add', ['filter' => 'authGuard']);
		$routes->post('add', 'Admin/MegamenuController::addConf', ['filter' => 'authGuard']);
		$routes->get('edit', 'Admin/MegamenuController::edit', ['filter' => 'authGuard']);
		$routes->post('edit', 'Admin/MegamenuController::editConf', ['filter' => 'authGuard']);

		
		$routes->group('sub-menu', function($routes){
			$routes->get('/', 'Admin/SubmenuController::index', ['filter' => 'authGuard']);
			$routes->get('add', 'Admin/SubmenuController::add', ['filter' => 'authGuard']);
			$routes->post('add', 'Admin/SubmenuController::addConf', ['filter' => 'authGuard']);
			$routes->get('edit', 'Admin/SubmenuController::edit', ['filter' => 'authGuard']);
			$routes->post('edit', 'Admin/SubmenuController::editConf', ['filter' => 'authGuard']);
		});

	});

	//Account Type
	$routes->group('account-type', function($routes){
		$routes->get('/', 'Admin/AccounttypeController::index', ['filter' => 'authGuard']);
		$routes->get('add', 'Admin/AccounttypeController::add', ['filter' => 'authGuard']);
		$routes->post('add', 'Admin/AccounttypeController::addConf', ['filter' => 'authGuard']);
		$routes->get('edit', 'Admin/AccounttypeController::edit', ['filter' => 'authGuard']);
		$routes->post('edit', 'Admin/AccounttypeController::editConf', ['filter' => 'authGuard']);
	});

	//User
	$routes->group('account', function($routes){
		$routes->get('/', 'Admin/AccountController::index', ['filter' => 'authGuard']);
		$routes->get('add', 'Admin/AccountController::add', ['filter' => 'authGuard']);
		$routes->post('add', 'Admin/AccountController::addConf', ['filter' => 'authGuard']);
		$routes->get('edit', 'Admin/AccountController::edit', ['filter' => 'authGuard']);
		$routes->post('edit', 'Admin/AccountController::editConf', ['filter' => 'authGuard']);
	});


	// Masters
	$routes->group('master', function($routes){

		$routes->group('gender', function($routes){
			$routes->get('/', 'Admin/MasterController::genders', ['filter' => 'authGuard']);
		});

		$routes->group('country', function($routes){
			$routes->get('/', 'Admin/MasterController::countrys', ['filter' => 'authGuard']);
		});

		$routes->group('state', function($routes){
			$routes->get('/', 'Admin/MasterController::stateByCountryId', ['filter' => 'authGuard']);
		});

		$routes->group('district', function($routes){
			$routes->get('/', 'Admin/MasterController::districtByStateId', ['filter' => 'authGuard']);
		});

		$routes->group('city', function($routes){
			$routes->get('/', 'Admin/MasterController::cityByStateId', ['filter' => 'authGuard']);
		});



	});


	$routes->group('calculator', function($routes){

		// Square Meter Calculator
		$routes->group('square-meter', function($routes){
			$routes->get('/', 'Admin/SquareMeterController::index', ['filter' => 'authGuard']);
		});
		
		// Carpet Calculator
		$routes->group('carpet', function($routes){
			$routes->get('/', 'Admin/SquareMeterController::carpet', ['filter' => 'authGuard']);
		});
		
		// Cushion Calculator
		$routes->group('cushion', function($routes){
			$routes->get('/', 'Admin/SquareMeterController::cushion', ['filter' => 'authGuard']);
		});
		
		// Carpet Tiles Calculator
		$routes->group('carpet-tiles-calculator', function($routes){
			$routes->get('/', 'Admin/SquareMeterController::carpet_tiles_calculator', ['filter' => 'authGuard']);
		});

	});


	// CMS

	// Site Info
	$routes->group('site-info', function($routes){
		$routes->get('/', 'Admin/SiteController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/SiteController::index_post', ['filter' => 'authGuard']);
	});

	// Social Link
	$routes->group('social-link', function($routes){
		$routes->get('/', 'Admin/SocialLinkController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/SocialLinkController::index_post', ['filter' => 'authGuard']);
	});


	// Category
	$routes->group('category', function($routes){
		$routes->get('/', 'Admin/CategoryController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/CategoryController::index_post', ['filter' => 'authGuard']);
	});

	// Tag
	$routes->group('tag', function($routes){
		$routes->get('/', 'Admin/TagController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/TagController::index_post', ['filter' => 'authGuard']);
	});

	// Post
	$routes->group('post', function($routes){
		$routes->get('/', 'Admin/PostController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/PostController::index_post', ['filter' => 'authGuard']);
	});

	// Image Slider Group
	$routes->group('image-slider-group', function($routes){
		$routes->get('/', 'Admin/ImageSliderGroupController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/ImageSliderGroupController::index_post', ['filter' => 'authGuard']);
	});

	// Image Slider
	$routes->group('image-slider', function($routes){
		$routes->get('/', 'Admin/ImageSliderController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/ImageSliderController::index_post', ['filter' => 'authGuard']);
		$routes->get('get/silder_form', 'Admin/ImageSliderController::ajax_add_slider', ['filter' => 'authGuard']);
	});

	


	

	
	// Post
	$routes->group('pages', function($routes){
		$routes->get('/', 'Admin/PageController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/PageController::index_post', ['filter' => 'authGuard']);
	});

	

	// Post
	$routes->group('newsletter', function($routes){
		$routes->get('/', 'Admin/NewsletterController::index', ['filter' => 'authGuard']);
	});

	// Post
	$routes->group('contact', function($routes){
		$routes->get('/', 'Admin/ContactController::index', ['filter' => 'authGuard']);
	});



	// Sections

	// Category
	$routes->group('section-category', function($routes){
		$routes->get('/', 'Admin/SectionCategoryController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/SectionCategoryController::index_post', ['filter' => 'authGuard']);
	});

	// Category
	$routes->group('section', function($routes){
		$routes->get('/', 'Admin/SectionController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/SectionController::index_post', ['filter' => 'authGuard']);
	});



	// Appearance

	$routes->group('home-design', function($routes){
		$routes->get('/', 'Admin/HomeDesignController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/HomeDesignController::index_post', ['filter' => 'authGuard']);
	});

	$routes->group('header-footer-meta', function($routes){
		$routes->get('/', 'Admin/HeaderFooterMetaController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/HeaderFooterMetaController::index_post', ['filter' => 'authGuard']);
	});

	$routes->group('front-end-menu', function($routes){
		$routes->get('/', 'Admin/MenuController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/MenuController::index_post', ['filter' => 'authGuard']);
	});

	$routes->group('front-end-menu-items', function($routes){
		$routes->get('/', 'Admin/MenuItemsController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/MenuItemsController::index_post', ['filter' => 'authGuard']);
	});


	//Master Color
	$routes->group('testimonial', function($routes){
		$routes->get('/', 'Admin/TestimonialController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Admin/TestimonialController::index_post', ['filter' => 'authGuard']);
	});
	
	


	// Masters

	//Master Category
	$routes->group('master-category', function($routes){
		$routes->get('/', 'Cwf/CategoryController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/CategoryController::index_post', ['filter' => 'authGuard']);
		
		



		$routes->get('specialization', 'Cwf/CategoryController::getSpecializationList', ['filter' => 'authGuard']);
		$routes->get('specialization/delete', 'Cwf/CategoryController::deleteSpecializationList', ['filter' => 'authGuard']);
		$routes->post('specialization/add', 'Cwf/CategoryController::addSpecializationList', ['filter' => 'authGuard']);

		// 
		$routes->get('features', 'Cwf/CategoryController::getFeaturesList', ['filter' => 'authGuard']);
		$routes->get('features/delete', 'Cwf/CategoryController::deleteFeaturesList', ['filter' => 'authGuard']);
		$routes->post('features/add', 'Cwf/CategoryController::addFeaturesList', ['filter' => 'authGuard']);




		$routes->get('dimensions', 'Cwf/CategoryController::getDimensionsList', ['filter' => 'authGuard']);
		$routes->get('dimensions/delete', 'Cwf/CategoryController::deleteDimensionsList', ['filter' => 'authGuard']);
		$routes->post('dimensions/add', 'Cwf/CategoryController::addDimensionsList', ['filter' => 'authGuard']);



		$routes->get('technical-information', 'Cwf/CategoryController::getTechInfoList', ['filter' => 'authGuard']);
		$routes->get('technical-information/delete', 'Cwf/CategoryController::deleteTechInfoList', ['filter' => 'authGuard']);
		$routes->post('technical-information/add', 'Cwf/CategoryController::addTechInfoList', ['filter' => 'authGuard']);


		$routes->get('attribute_category', 'Cwf/CategoryController::getAttrCatList', ['filter' => 'authGuard']);
		$routes->get('attribute_category/delete', 'Cwf/CategoryController::deleteAttrCatList', ['filter' => 'authGuard']);
		$routes->post('attribute_category/add', 'Cwf/CategoryController::addAttrCatList', ['filter' => 'authGuard']);
    
        $routes->post('upload/banner-images', 'Cwf/CategoryController::uploadBannerImages', ['filter' => 'authGuard']);
		$routes->get('edit/banner-images', 'Cwf/CategoryController::editBannerImage', ['filter' => 'authGuard']);
		$routes->post('edit/banner-images', 'Cwf/CategoryController::editBannerImageConf', ['filter' => 'authGuard']);
		
	});

	//Master Sub Category
	$routes->group('master-sub-category', function($routes){
		$routes->get('/', 'Cwf/SubCategoryController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/SubCategoryController::index_post', ['filter' => 'authGuard']);
	});

	//Master Collection
	$routes->group('master-collection', function($routes){
		$routes->get('/', 'Cwf/CollectionController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/CollectionController::index_post', ['filter' => 'authGuard']);
	});

    //Master Collection
	$routes->group('range', function($routes){
		$routes->get('/', 'Cwf/RangeController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/RangeController::index_post', ['filter' => 'authGuard']);
	});

    //Master Shades
	$routes->group('master-shades', function($routes){
		$routes->get('/', 'Cwf/ShadesController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/ShadesController::index_post', ['filter' => 'authGuard']);
	});


	//Master Color
	$routes->group('master-color', function($routes){
		$routes->get('/', 'Cwf/ColorController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/ColorController::index_post', ['filter' => 'authGuard']);
	});

	//Master Product Tags
	$routes->group('master-product-tags', function($routes){
		$routes->get('/', 'Cwf/ProductTagsController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/ProductTagsController::index_post', ['filter' => 'authGuard']);
	});

	//Master Product Brand
	$routes->group('master-brand', function($routes){
		$routes->get('/', 'Cwf/ProductBrand::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/ProductBrand::index_post', ['filter' => 'authGuard']);
	});

	

	//Master Attribute category
	$routes->group('master-attribute-category', function($routes){
		$routes->get('/', 'Cwf/AttrCategoryController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/AttrCategoryController::index_post', ['filter' => 'authGuard']);
	});

	//Master Attribute category
	$routes->group('specialization', function($routes){
		$routes->get('/', 'Cwf/SpecializationController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/SpecializationController::index_post', ['filter' => 'authGuard']);
	});

	//Master features
	$routes->group('features', function($routes){
		$routes->get('/', 'Cwf/FeaturesController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/FeaturesController::index_post', ['filter' => 'authGuard']);
	});

	//Master features
	$routes->group('filters', function($routes){
		$routes->get('/', 'Cwf/FiltersController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/FiltersController::index_post', ['filter' => 'authGuard']);
	});


	//Master features
	$routes->group('filter-options', function($routes){
		$routes->get('/', 'Cwf/FiltersOptionsController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/FiltersOptionsController::index_post', ['filter' => 'authGuard']);

		$routes->get('ajax/list', 'Cwf/FiltersOptionsController::ajax_list', ['filter' => 'authGuard']);
		
	});
	
	
	//Master Country
	$routes->group('country', function($routes){
		$routes->get('/', 'Cwf/CountryController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/CountryController::index_post', ['filter' => 'authGuard']);
	});

	//Master STATE
	$routes->group('state', function($routes){
		$routes->get('/', 'Cwf/StateController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/StateController::index_post', ['filter' => 'authGuard']);
	});

	//Master ciTY
	$routes->group('city', function($routes){
		$routes->get('/', 'Cwf/CityController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/CityController::index_post', ['filter' => 'authGuard']);
	});



	//Master Dimensions
	$routes->group('dimensions', function($routes){
		$routes->get('/', 'Cwf/DimensionsController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/DimensionsController::index_post', ['filter' => 'authGuard']);
	});

	//Master Dimensions
	$routes->group('semplebook', function($routes){
		
		$routes->get('/', 'Cwf/SempleBookController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/SempleBookController::index_post', ['filter' => 'authGuard']);

	});

	//Master Technical Information
	$routes->group('technical-information', function($routes){
		$routes->get('/', 'Cwf/TechnicalInfoController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/TechnicalInfoController::index_post', ['filter' => 'authGuard']);
	});


	//Master Attribute category
	$routes->group('master-manufacturer', function($routes){
		$routes->get('/', 'Cwf/ManufacturerController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/ManufacturerController::index_post', ['filter' => 'authGuard']);
	});

	// Charnwood Flooring Routes

	// Supplier
	$routes->group('supplier', function($routes){
		$routes->get('/', 'Cwf/SupplierController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/SupplierController::index_post', ['filter' => 'authGuard']);
	});

// Supplier2
	$routes->group('supplier-portal', function($routes){
		$routes->get('/', 'Cwf/SupplierPortalController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/SupplierPortalController::index_post', ['filter' => 'authGuard']);
	});




	// Clients
	$routes->group('client', function($routes){
		$routes->get('/', 'Cwf/ClientController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/ClientController::index_post', ['filter' => 'authGuard']);
	});

	// Clients
	$routes->group('largesse', function($routes){
		$routes->get('/', 'Cwf/LargesseController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/LargesseController::index_post', ['filter' => 'authGuard']);
	});


	// Fitter
	$routes->group('fitter', function($routes){
		$routes->get('/', 'Cwf/FitterController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/FitterController::index_post', ['filter' => 'authGuard']);
	});


	//  Product 
	$routes->group('product', function($routes){
		$routes->get('/', 'Cwf/ProductController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/ProductController::index_post', ['filter' => 'authGuard']);
		
		$routes->post('upload/banner-images', 'Cwf/ProductController::uploadBannerImages', ['filter' => 'authGuard']);
		$routes->get('edit/banner-images', 'Cwf/ProductController::editBannerImage', ['filter' => 'authGuard']);
		$routes->post('edit/banner-images', 'Cwf/ProductController::editBannerImageConf', ['filter' => 'authGuard']);
		
    // 	Documents
		    
		$routes->post('upload/documents', 'Cwf/ProductController::uploadDocuments', ['filter' => 'authGuard']);
		$routes->get('edit/documents', 'Cwf/ProductController::editDocuments', ['filter' => 'authGuard']);
		$routes->post('edit/documents', 'Cwf/ProductController::editDocumentConf', ['filter' => 'authGuard']);
		
		

		$routes->get('delete/product-varient', 'Cwf/ProductController::deleteProductVariant', ['filter' => 'authGuard']);
	});

    // orders
	$routes->group('orders', function($routes){
		$routes->get('/', 'Cwf/OrderController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/OrderController::index_post', ['filter' => 'authGuard']);
	});

    
    
	$routes->get('delete', 'Cwf/DeleteController::index', ['filter' => 'authGuard']);
	$routes->get('delete/category', 'Cwf/DeleteController::deleteCategory', ['filter' => 'authGuard']);
	
	
	//Master Units
	$routes->group('units', function($routes){
		$routes->get('/', 'Cwf/UnitsController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/UnitsController::index_post', ['filter' => 'authGuard']);
	});


    // vouchers
	$routes->group('vouchers', function($routes){
		$routes->get('/', 'Cwf/VouchersController::index', ['filter' => 'authGuard']);
		$routes->post('/', 'Cwf/VouchersController::index_post', ['filter' => 'authGuard']);
	});


});


$routes->group('ajax', function($routes){
	$routes->post('state/list', 'Ajax::stateByCountryId');
	$routes->post('city/list', 'Ajax::cityByStateId');

	$routes->post('upload/post/featured_image', 'Ajax::upload_post_featured_image');
	$routes->post('upload/page/featured_image', 'Ajax::upload_page_featured_image');
	$routes->post('update/post/preview/content', 'Ajax::ajaxUpdatePostPreviewContent', ['filter' => 'authGuard']);

	$routes->post('upload/image/slider_image', 'Ajax::upload_image_slider_image');



	$routes->get('update/ordering', 'Cwf/Ajax::ajaxUpdateOrder', ['filter' => 'authGuard']);
	$routes->get('get/sub-category', 'Cwf/Ajax::getSubCategory', ['filter' => 'authGuard']);
	$routes->get('get/product', 'Cwf/Ajax::getProductBySubCatID', ['filter' => 'authGuard']);
});


// Live Preview

$routes->group('preview', function($routes){
	$routes->get('post', 'Admin/PostController::live_preview');
});






############################### END	ADMIN ROUTES #############################

$routes->get('/(:any)/(:any)/(:any)', 'ProductDetailsController::index/$1/$2/$3');

$routes->get('/(:any)/(:any)', 'CategoryController::index/$1/$2');



/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
