<?php 
namespace App\Controllers\Admin;
use App\Models\CategoryModel;
use App\Controllers\BaseController;

class CategoryController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $list = new CategoryModel();
        $data['list'] = $list->where('cat_active','A')->orderby('cat_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/category/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $list = new CategoryModel();
        $data['list'] = $list->where('cat_active','A')->orderby('cat_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/category/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $category = new CategoryModel();
        if($data['slug'])
        {
            $slug = $data['slug'];
        }else
        {
            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $category->where('cat_name', $data['title'])->findAll();
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }
        }

        $save_data = array(
                            'cat_hash'=> createHash(),
                            'cat_name'=> $data['title'],
                            'cat_slug'=> $slug,
                            'cat_description'=> $data['description'],
                            'cat_status' => $data['status'],
                            'cat_active' => 'A',
                            'cat_created_id' => dsession_id(),
                        );

        if($data['parent_category'])
        {
            $save_data['cat_parent_id'] = $data['parent_category'];
        }

        if($category->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $list = new CategoryModel();
        $data['cat_data'] = $list->where('cat_active','A')->where('cat_hash', $token)->first();
        $data['list'] = $list->where('cat_active','A')->orderby('cat_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/category/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $category = new CategoryModel();
        $save_data = array(
                            'cat_name'=> $data['title'],
                            'cat_slug'=> $data['slug'],
                            'cat_description'=> $data['description'],
                            'cat_status' => $data['status'],
                            'cat_updated_at' => date("Y-m-d h:i:s"),
                            'cat_updated_id' => dsession_id(),
                        );
        if($data['parent_category'])
        {
            $save_data['cat_parent_id'] = $data['parent_category'];
        }

        if($category->where('cat_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

