<?php 
namespace App\Controllers\Admin;
use App\Models\ImageSliderModel;
use App\Models\ImageSliderGroupModel;
use App\Controllers\BaseController;

class ImageSliderController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            // $this->list();
            $this->create();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $list = new ImageSliderModel();
        $data['list'] = $list->where('is_active','A')->orderby('is_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/image_slider_group/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $list = new ImageSliderGroupModel();
        $data['list'] = $list->where('isg_active','A')->orderby('isg_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/image_slider/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {

        // echo "<pre>";
        // print_r($data);
        // exit();

        $main_model = new ImageSliderModel();
        $validated = $this->validate([
            'file' => [
                'uploaded[file]',
                'mime_in[file,image/jpg,image/jpeg,image/gif,image/png]',
                'max_size[file,4096]',
            ],
        ]);
 
       
  
        if($validated) {
            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/media/slider/', $newName);
 
            $save_data = array(
                            'is_hash'=> createHash(),
                            'is_isg_id' => $data['image_group'],
                            'is_title'=> $data['title'],
                            'is_sub_title'=> $data['sub_title'],
                            'is_img_src'=> $newName,
                            'is_link'=> $data['link'],
                            'is_link_text'=> $data['link_text'],
                            'is_img_alt'=> $data['alt'],
                            'is_status' => $data['status'],
                            'is_active' => 'A',
                            'is_created_at' => date("Y-m-d h:i:s"),
                            'is_updated_at' => date("Y-m-d h:i:s"),
                            'is_created_id' => dsession_id(),
                            'is_updated_id' => dsession_id(),
                        );

            

            if($main_model->insert($save_data))
            {
               session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url());
            }else
            {
                session()->setFlashdata("error", "Opration Not Complete");
                return $this->response->redirect(current_url());
            }

        }else{
             session()->setFlashdata("error", "Opration Not Complete");
                return $this->response->redirect(current_url());
        }







      
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $main_model = new ImageSliderModel();
        $data['data'] = $main_model->where('is_active','A')->where('is_hash', $token)->first();
        if(!$data['data']){return $this->response->redirect(site_url());}
        echo view('Admin/include/header');
        echo view('Admin/image_slider/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $main_model = new ImageSliderModel();
        $save_data = array(
                            'is_title'=> $data['title'],
                            'is_sub_title'=> $data['sub_title'],
                            'is_link'=> $data['link'],
                            'is_link_text'=> $data['link_text'],
                            'is_img_alt'=> $data['alt'],
                            'is_status' => $data['status'],
                            'is_updated_at' => date("Y-m-d h:i:s"),
                            'is_updated_id' => dsession_id(),
                        );

        if($main_model->where('is_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }




    public function ajax_add_slider()
    {
        $code = $this->request->getGet('code');

        $main_model = new ImageSliderGroupModel();
        $data['data'] = $main_model->where('isg_active','A')->where('isg_code', $code)->first();
        
        $image_slider = new ImageSliderModel();
        $data['list'] = $image_slider->where('is_isg_id' , $data['data']['isg_id'])->where('is_active', 'A')->orderby('is_id', 'DESC')->findAll();

        if(!$data['data']){return false;}

        echo view('Admin/image_slider/ajax_form', $data);
    }










}

