<?php 
namespace App\Controllers\Admin;
use App\Models\Mega_menuModel;
use App\Controllers\BaseController;

class MegamenuController extends BaseController
{

	public function index()
	{
		$mega_menuModel = new Mega_menuModel();
        $dyanmicData['megamenu'] = $mega_menuModel->orderBy('mm_order_by', 'ASC')->findAll();

        echo view('Admin/include/header');
		echo view('Admin/mega_menu/list', $dyanmicData);
		echo view('Admin/include/footer');
        
	}

	public function add()
	{
		$this->template('Admin/mega_menu/add');
	}

	public function addConf()
	{
		// echo "<pre>";
		// print_r($this->request->getVar());
		$mega_menuModel = new Mega_menuModel();
        $data = [
            'mm_name' => $this->request->getVar('title'),
            'mm_icon'  => $this->request->getVar('icon'),
            'mm_status'  => $this->request->getVar('status'),
            'mm_direct_link_checkbox'  => $this->request->getVar('direct_menu_link'),
            'mm_direct_link'  => $this->request->getVar('direct_link'),
            'mm_created_ip'  => $this->request->getIPAddress(),
            'mm_created_id' => '',
            'mm_created_at' => '',
            'mm_active'=> 'A'
        ];

        if($mega_menuModel->insert($data))
        {
        	session()->setFlashdata("success", "Opration Successfull...");
        	return $this->response->redirect(site_url(uri_string()));
        }else
        {
        	session()->setFlashdata("error", "Opration Not Completed...");
        	return $this->response->redirect(site_url(uri_string()));
        }

        
	}


    public function edit()
    {
        $uri_id = $this->request->getGet('id');
        $mega_menuModel = new Mega_menuModel();
        $data['megaMenuData'] = $mega_menuModel->where('mm_id', $uri_id)->first();

        echo view('Admin/include/header');
        echo view('Admin/mega_menu/edit', $data);
        echo view('Admin/include/footer');
    }
    public function editConf()
    {
       
        $uri_id = $this->request->getGet('id');
        $mega_menuModel = new Mega_menuModel();
        $data = [
            'mm_name' => $this->request->getVar('title'),
            'mm_icon'  => $this->request->getVar('icon'),
            'mm_status'  => $this->request->getVar('status'),
            'mm_direct_link'  => $this->request->getVar('direct_link'),
            'mm_order_by' => $this->request->getVar('order'),
            'mm_updated_ip'  => $this->request->getIPAddress(),
            'mm_updated_id' => dsession_id(),
            'mm_updated_at' => date("Y-m-d h:i:s"),
        ];


        if($mega_menuModel->where('mm_id', $uri_id)->set($data)->update())
        {
            session()->setFlashdata("success", "Opration Successfull...");
            return $this->response->redirect(site_url('admin/mega-menu'));
        }else
        {
            session()->setFlashdata("error", "Opration Not Completed...");
            return $this->response->redirect(current_url());
        }
    }



	public function template($main_view)
	{
		echo view('Admin/include/header');
		echo view($main_view);
		echo view('Admin/include/footer');
	}

	


}

