<?php 
namespace App\Controllers\Admin;
use App\Models\PageModel;
use App\Controllers\BaseController;

class MenuItemsController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('fe_menu');

        if(isset($_GET['sub_parent']))
        {
            $data['list'] = $db->where('fem_active','A')->orderby('fem_order', 'ASC')->where('fem_parent_type', $_GET['parent'])->where('fem_parent_item', $_GET['sub_parent'])->get()->getResult();
        }else
        {
            //echo $_GET['parent'];
            $data['list'] = $db->where('fem_active','A')->orderby('fem_order', 'ASC')->where('fem_parent_type', $_GET['parent'])->where('fem_parent_item', '')->get()->getResult();  
        }

            echo view('Admin/include/header');
            echo view('Admin/menus_items/list', $data);
            echo view('Admin/include/footer');
        
    }

    // CREATE
    public function create()
    {
        $db = \Config\Database::connect()->table('fe_menu');
        $data['list'] = $db->where('fem_active','A')->orderby('fem_name', 'ASC')->where('fem_parent_type', $_GET['parent'])->get()->getResult();

        $db = \Config\Database::connect()->table('sections');
        $data['section_list'] = $db->where('section_active','A')->orderby('section_id', 'DESC')->join('section_categorys', 'section_category = section_categorys.section_cat_id')->get()->getResult();

        $list = new PageModel();
        $data['page_list'] = $list->where('page_active','A')->orderby('page_id', 'DESC')->findAll();

        echo view('Admin/include/header');
        echo view('Admin/menus_items/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {

        // echo "<pre>";
        // print_r($data);
        // exit();

        $db = \Config\Database::connect()->table('fe_menu');

        $results = $db->where('fem_parent_type', $data['parent'])->get()->getResult();
       
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
            }else
            {
                $count_result = '1';
            }

        $save_data = array(
                            'fem_hash'=> createHash(),
                            'fem_name'=> $data['title'],
                            'fem_item_type' => $data['type'],
                            'fem_parent_type' => $data['parent'],
                            'fem_order' => $count_result,
                            'fem_status' => $data['status'],
                            'fem_active' => 'A',
                            'fem_created_ip' => $this->request->getIPAddress(),
                            'fem_created_id' => dsession_id(),
                            'fem_updated_ip'  => $this->request->getIPAddress(),
                            'fem_updated_id' => dsession_id(),
                            'fem_updated_at' => date("Y-m-d h:i:s"),
                        );
        if(isset($data['open_new_tab']))
        {
            $save_data['fem_open_new_tab'] = $data['open_new_tab'];
        }
        if(isset($data['parent_menu']))
        {
            $save_data['fem_parent_item'] = $data['parent_menu'];
        }
        if(isset($data['link']))
        {
            $save_data['fem_slug'] = $data['link'];
        }
        if(isset($data['page']))
        {
            $save_data['fem_page_id'] = $data['page'];
        }
        if(isset($data['section']))
        {
            $save_data['fem_section_id'] = $data['section'];
        }

    
        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url().'?parent='.$data['parent']);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
             return $this->response->redirect(current_url().'?parent='.$data['parent']);
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');
        $db = \Config\Database::connect()->table('fe_menu');
        $data['details'] =  $db->where('fem_active','A')->where('fem_hash', $token)->get()->getRow();

        $db = \Config\Database::connect()->table('fe_menu');
        $data['list'] = $db->where('fem_active','A')->orderby('fem_name', 'ASC')->where('fem_parent_type', $_GET['parent'])->get()->getResult();

        $db = \Config\Database::connect()->table('sections');
        $data['section_list'] = $db->where('section_active','A')->orderby('section_id', 'DESC')->join('section_categorys', 'section_category = section_categorys.section_cat_id')->get()->getResult();

        $list = new PageModel();
        $data['page_list'] = $list->where('page_active','A')->orderby('page_id', 'DESC')->findAll();

        echo view('Admin/include/header');
        echo view('Admin/menus_items/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('fe_menu');
        $save_data = array(
                            'fem_name'=> $data['title'],
                            'fem_item_type' => $data['type'],
                            'fem_parent_type' => $data['parent'],
                            'fem_order' =>  $data['order'],
                            'fem_status' => $data['status'],
                            'fem_updated_ip'  => $this->request->getIPAddress(),
                            'fem_updated_id' => dsession_id(),
                            'fem_updated_at' => date("Y-m-d h:i:s"),
                        );

        if(isset($data['open_new_tab']))
        {
            $save_data['fem_open_new_tab'] = $data['open_new_tab'];
        }
        if(isset($data['parent_menu']))
        {
            $save_data['fem_parent_item'] = $data['parent_menu'];
        }
        if(isset($data['link']))
        {
            $save_data['fem_slug'] = $data['link'];
        }
        if(isset($data['page']))
        {
            $save_data['fem_page_id'] = $data['page'];
        }
        if(isset($data['section']))
        {
            $save_data['fem_section_id'] = $data['section'];
        }
        
        if($db->where('fem_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url().'?parent='.$data['parent']);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?parent='.$data['parent']);
        }

    }

}

