<?php 
namespace App\Controllers\Admin;
use App\Models\SiteModel;
use App\Controllers\BaseController;

class SiteController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            // $this->list();
            $this->edit();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();

                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );

                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $postData = $this->request->getVar();
            $postData['token'] = '1f9e2b60d2f6836acaafce34f44968ac15f074294b0fcb6a57bc3359ebfcea34';
            $custome_data = array(
                                        
                                    );
            $this->edit_conf($postData, $custome_data);
        }
    }

    // LIST
    public function list()
    {
        $list = new SiteModel();
        $data['list'] = $list->where('tag_active','A')->orderby('tag_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/tag/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $list = new SiteModel();
        $data['list'] = $list->where('tag_active','A')->orderby('tag_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/tag/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $tag = new TagModel();
        if($data['slug'])
        {
            $slug = $data['slug'];
        }else
        {
            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $tag->where('tag_name', $data['title'])->findAll();
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }
        }

        $save_data = array(
                            'tag_hash'=> createHash(),
                            'tag_name'=> $data['title'],
                            'tag_slug'=> $slug,
                            'tag_description'=> $data['description'],
                            'tag_status' => $data['status'],
                            'tag_active' => 'A',
                            'tag_created_id' => dsession_id(),
                        );


        if($tag->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');
        $token = '1f9e2b60d2f6836acaafce34f44968ac15f074294b0fcb6a57bc3359ebfcea34';
        $list = new SiteModel();
        $data['site_data'] = $list->where('site_hash', $token)->first();
        echo view('Admin/include/header');
        echo view('Admin/site_info/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        // echo "<pre>";
        // print_r($data);
        // exit();

        $site_model = new SiteModel();
        $save_data = array(
                            'site_title'=> $data['title'],
                            'site_tag_line'=> $data['tag_line'],
                            'site_description'=> $data['description'],
                            'site_primary_email' => $data['email'],
                            'site_secondary_email' => $data['email2'],
                            'site_copyright' => $data['copyright'],
                            'site_primary_contact_no' => $data['number'],
                            'site_secondary_contact_no' => $data['number2'],
                            'site_primary_address' => $data['address1'],
                            'site_secondary_address' => $data['address2'],
                            'quo_full_address'=> $data['full_address'],
                            'quo_bank_name'=> $data['bank_name'],
                            'quo_account_name'=> $data['account_name'],
                            'quo_sort_code'=> $data['sort_code'],
                            'quo_account_no'=> $data['account_no'],
                            'quo_terms'=> $data['terms'],
                            'quo_additional_notes'=> $data['additional_notes'],
                            'quo_customer_notes'=> $data['customer_notes'],
                            'site_updated_at' => date("Y-m-d h:i:s"),
                            'site_updated_id' => dsession_id(),
                            'site_vat'=> $data['site_vat'],
                            'site_vat_status'=> $data['site_vat_status'],
                        );

        if($site_model->where('site_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

