<?php 
namespace App\Controllers\Admin;
use App\Models\Sub_menuModel;
use App\Controllers\BaseController;

class SubmenuController extends BaseController
{

	public function index()
	{
        $parent_id = $this->request->getGet('id');

		$sub_menuModel = new Sub_menuModel();
        $dyanmicData['submenu'] = $sub_menuModel->orderBy('mmi_ordering', 'ASC')->where('mmi_parent_id', $parent_id)->findAll();

        echo view('Admin/include/header');
		echo view('Admin/sub_menu/list', $dyanmicData);
		echo view('Admin/include/footer');
        
	}
    

	public function add()
	{
		$this->template('Admin/sub_menu/add');
	}

	public function addConf()
	{
        $parent_id = $this->request->getGet('id');
		$sub_menuModel = new Sub_menuModel();
        $data = [
            'mmi_parent_id' => $parent_id,
            'mmi_name' => $this->request->getVar('title'),
            'mmi_icon'  => $this->request->getVar('icon'),
            'mmi_slug'  => $this->request->getVar('slug'),
            'mmi_status'  => $this->request->getVar('status'),
            'mmi_created_ip'  => $this->request->getIPAddress(),
            'mmi_created_id' => '',
            'mmi_created_at' => '',
            'mmi_active'=> 'A'
        ];

        if($sub_menuModel->insert($data))
        {
        	session()->setFlashdata("success", "Opration Successfull...");
        	return $this->response->redirect(site_url('admin/mega-menu/sub-menu?id='.$this->request->getGet('id')));
        }else
        {
        	session()->setFlashdata("error", "Opration Not Completed...");
        	return $this->response->redirect(site_url('admin/mega-menu/sub-menu?id='.$this->request->getGet('id')));
        }

        
	}

    public function edit()
    {
        $uri_id = $this->request->getGet('id');
        $sub_menuModel = new Sub_menuModel();
        $data['subMenuData'] = $sub_menuModel->where('mmi_id', $uri_id)->first();

        echo view('Admin/include/header');
        echo view('Admin/sub_menu/edit', $data);
        echo view('Admin/include/footer');
    }
    public function editConf()
    {
       
        $uri_id = $this->request->getGet('id');
        $sub_menuModel = new Sub_menuModel();
        $subMenuData = $sub_menuModel->where('mmi_id', $uri_id)->first();
        // echo "<pre>";
        // print_r($subMenuData);
        // exit();
        $data = [
            'mmi_name' => $this->request->getVar('title'),
            'mmi_icon'  => $this->request->getVar('icon'),
            'mmi_slug'  => $this->request->getVar('slug'),
            'mmi_status'  => $this->request->getVar('status'),
            'mmi_ordering' => $this->request->getVar('order'),
            'mmi_updated_ip'  => $this->request->getIPAddress(),
            'mmi_updated_id' => dsession_id(),
            'mmi_updated_at' => date("Y-m-d h:i:s"),
        ];

        // echo "<pre>";
        // print_r($data);
        // exit();

        if($sub_menuModel->where('mmi_id', $uri_id)->set($data)->update())
        {
            session()->setFlashdata("success", "Opration Successfull...");
            return $this->response->redirect(site_url('admin/mega-menu/sub-menu/?id='.$subMenuData['mmi_parent_id']));
        }else
        {
            session()->setFlashdata("error", "Opration Not Completed...");
            return $this->response->redirect(current_url());
        }
    }



	public function template($main_view)
	{
		echo view('Admin/include/header');
		echo view($main_view);
		echo view('Admin/include/footer');
	}

	


}

