<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class AttrCategoryController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('cwf_attribute_category');
        $data['list'] = $db->where('cwf_attr_cat_active','A')->orderby('cwf_attr_cat_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/attr-category/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Cwf/attr-category/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_attribute_category');

            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $db->where('cwf_attr_cat_name', $data['title'])->get()->getResult();
            $results_count = $db->get()->getResult();

            if($results)
            {
                session()->setFlashdata("error", "Data Not Unique");
                return $this->response->redirect(current_url());
            }

            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }

        $save_data = array(
                            'cwf_attr_cat_hash'=> createHash(),
                            'cwf_attr_cat_name'=> $data['title'],
                            'cwf_attr_cat_slug'=> $slug,
                            'cwf_attr_cat_order' => count($results_count) + 1 ,
                            'cwf_attr_cat_description'=> $data['description'],
                            'cwf_attr_cat_status' => $data['status'],
                            'cwf_attr_cat_active' => 'A',
                            'cwf_attr_cat_created_at' => date("Y-m-d h:i:s"),
                            'cwf_attr_cat_created_ip' => $this->request->getIPAddress(),
                            'cwf_attr_cat_created_id' => dsession_id(),
                            'cwf_attr_cat_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_attr_cat_updated_id' => dsession_id(),
                            'cwf_attr_cat_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('cwf_attribute_category');
        $data['cat_data'] = (array) $db->where('cwf_attr_cat_active','A')->where('cwf_attr_cat_hash', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/attr-category/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_attribute_category');


        $save_data = array(
                            'cwf_attr_cat_name'=> $data['title'],
                            'cwf_attr_cat_slug'=> $data['slug'],
                            'cwf_attr_cat_description'=> $data['description'],
                            'cwf_attr_cat_status' => $data['status'],
                            'cwf_attr_cat_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_attr_cat_updated_id' => dsession_id(),
                            'cwf_attr_cat_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('cwf_attr_cat_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

