<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class FeaturesController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = dbconnect('cwf_features');
        $data['list'] = $db->where('cwff_active','1')->orderby('cwff_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/features/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Cwf/features/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = dbconnect('cwf_features');

           
            $results = $db->where('cwff_name', $data['title'])->where('cwff_active','1')->get()->getResult();
            $results_count = $db->get()->getResult();

            if($results)
            {
                session()->setFlashdata("error", "Data Not Unique");
                return $this->response->redirect(current_url());
            }

            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
            }

        $save_data = array(
                            'cwff_hash'=> createHash(),
                            'cwff_name'=> $data['title'],
                            'cwff_order' => count($results_count) + 1 ,
                            'cwff_status' => $data['status'],
                            'cwff_active' => '1',
                            'cwff_created_at' => date("Y-m-d h:i:s"),
                            'cwff_created_ip' => $this->request->getIPAddress(),
                            'cwff_created_id' => dsession_id(),
                            'cwff_updated_ip'  => $this->request->getIPAddress(),
                            'cwff_updated_id' => dsession_id(),
                            'cwff_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = dbconnect('cwf_features');
        $data['cat_data'] = (array) $db->where('cwff_active','1')->where('cwff_hash', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/features/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = dbconnect('cwf_features');


        $save_data = array(
                            'cwff_name'=> $data['title'],
                            'cwff_status' => $data['status'],
                            'cwff_updated_ip'  => $this->request->getIPAddress(),
                            'cwff_updated_id' => dsession_id(),
                            'cwff_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('cwff_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

