<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class OrderController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->createInvoice();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
         $db = \Config\Database::connect()->table('order');
        if(isset($_GET['page']))
        {
            $data['list'] = $db->orderby('o_id', 'DESC')->where('o_status', $_GET['page'])->get()->getResult();
        }else
        {
            $data['list'] = $db->orderby('o_id', 'DESC')->get()->getResult();
        }
        echo view('Admin/include/header');
        echo view('Cwf/orders/list', $data);
        echo view('Admin/include/footer');
    }

    

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('order');
        $data['details'] =  $db->where('o_hash', $token)->get()->getRow();

        $db = dbconnect('order_cart_items');
        $data['list'] = $db->where('oci_order_id', $data['details']->o_id)->join('cwf_products', 'oci_prod_id = cwf_products.pro_id')->get()->getResult();


        echo view('Admin/include/header');
        echo view('Cwf/orders/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('order');


        $save_data = array(
                            'o_status' => $data['status'],
                            '0_updated_ip'  => $this->request->getIPAddress(),
                            '0_updated_id' => dsession_id(),
                            '0_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('o_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }
    
    public function createInvoice()
    {
        $token = $_GET['order_id'];
        $db = dbconnect('cwf_invoice');

        $data = $db->where('cwf_inv_order_id', $token)->get()->getRow();
        if(empty($data))
        {   

            $save_data = array(
                            'cwf_inv_hash'=> createHash(),
                            'cwf_inv_order_id'=> $token,
                            'cwf_inv_payment_status' => 'P',
                            'cwf_inv_status' => 'A',
                            'cwf_inv_active' => '1',
                            'cwf_inv_created_at' => date("Y-m-d h:i:s"),
                            'cwf_inv_created_ip' => $this->request->getIPAddress(),
                            'cwf_inv_created_id' => dsession_id(),
                            'cwf_inv_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_inv_updated_id' => dsession_id(),
                            'cwf_inv_updated_at' => date("Y-m-d h:i:s"),
                        );

            if($db->insert($save_data))
            {
                session()->setFlashdata("success", "Invoice Created");
                return $this->response->redirect(current_url());
            }else
            {
                 session()->setFlashdata("error", "Invoice Not Created");
                return $this->response->redirect(current_url());
            }

        }else
        {
            session()->setFlashdata("error", "Invoice Already Created");
            return $this->response->redirect(current_url());
        }
    }



}

