<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class ProductBrand extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = dbconnect('cwf_brand');
        $data['list'] = $db->where('cwfb_active','A')->orderby('cwfb_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/brand/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $db = dbconnect('cwf_manufacturer');
        $data['list'] = $db->where('cwf_mf_active','A')->where('cwf_mf_status','A')->orderby('cwf_mf_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/brand/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = dbconnect('cwf_brand');
            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $db->where('cwfb_name', $data['title'])->get()->getResult();
            $results_count = $db->get()->getResult();
           
            if($results)
            {
                session()->setFlashdata("error", "Color Not Unique");
                return $this->response->redirect(current_url());
            }

        
        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png]',
                    'max_size[file,1024]',
                ],
            ]);
            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url()); 
            }

            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/brand/', $newName);
        }else
        {
            $newName = '';
        }



        $save_data = array(
                            'cwfb_hash'=> createHash(),
                            'cwfb_name'=> $data['title'],
                            'cwfb_manufacturer'=> $data['manufacturer'],
                            'cwfb_image' => $newName,
                            'cwfb_order' => count($results_count) + 1 ,
                            'cwfb_status' => $data['status'],
                            'cwfb_active' => 'A',
                            'cwfb_created_at' => date("Y-m-d h:i:s"),
                            'cwfb_created_ip' => $this->request->getIPAddress(),
                            'cwfb_created_id' => dsession_id(),
                            'cwfb_updated_ip'  => $this->request->getIPAddress(),
                            'cwfb_updated_id' => dsession_id(),
                            'cwfb_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');
        $db = dbconnect('cwf_manufacturer');
        $data['list'] = $db->where('cwf_mf_active','A')->where('cwf_mf_status','A')->orderby('cwf_mf_order', 'ASC')->get()->getResult();
        $db = dbconnect('cwf_brand');
        $data['details'] = (array) $db->where('cwfb_active','A')->where('cwfb_hash', $token)->get()->getRow();
        
        echo view('Admin/include/header');
        echo view('Cwf/brand/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = dbconnect('cwf_brand');

        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png]',
                    'max_size[file,1024]',
                ],
            ]);
            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url()); 
            }

            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/brand/', $newName);
        }else
        {
            $newName = '';
        }

        $save_data = array(
                            'cwfb_name'=> $data['title'],
                            'cwfb_manufacturer'=> $data['manufacturer'],
                            'cwfb_status' => $data['status'],
                            'cwfb_updated_ip'  => $this->request->getIPAddress(),
                            'cwfb_updated_id' => dsession_id(),
                            'cwfb_updated_at' => date("Y-m-d h:i:s"),
                        );
        
        if($newName)
        {
            $save_data['cwfb_image'] = $newName;
        }

        if($db->where('cwfb_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}


?>


