<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class RangeController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $coll_id = $_GET['id'];

        $db = \Config\Database::connect()->table('cwf_range');
        $data['list'] = $db->where('cwf_rng_active','A')->orderby('cwf_rng_order', 'ASC')->where('cwf_rng_coll_id', $coll_id)->join('cwf_collections', 'cwf_rng_coll_id = cwf_collections.cwf_coll_id')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/range/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {

        $db = \Config\Database::connect()->table('cwf_collections');
            $data['col_list'] = $db->where('cwf_coll_active','A')->where('cwf_coll_status','A')->orderby('cwf_coll_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/range/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_range');

            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $db->where('cwf_rng_name', $data['title'])->where('cwf_rng_coll_id', $data['parent_category'])->get()->getResult();
            $results_count = $db->where('cwf_rng_coll_id', $data['parent_category'])->get()->getResult();

            if($results)
            {
                session()->setFlashdata("error", "rngection Not Unique");
                return $this->response->redirect(current_url());
            }

            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }

        $save_data = array(
                            'cwf_rng_hash'=> createHash(),
                            'cwf_rng_name'=> $data['title'],
                            'cwf_rng_slug'=> $slug,
                            'cwf_rng_description'=> $data['description'],
                            'cwf_rng_order' => count($results_count)+1,
                            'cwf_rng_status' => $data['status'],
                            'cwf_rng_coll_id' => $data['parent_category'],
                            'cwf_rng_active' => 'A',
                            'cwf_rng_created_at' => date("Y-m-d h:i:s"),
                            'cwf_rng_created_ip' => $this->request->getIPAddress(),
                            'cwf_rng_created_id' => dsession_id(),
                            'cwf_rng_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_rng_updated_id' => dsession_id(),
                            'cwf_rng_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url().'?id='.$_GET['id']);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?id='.$_GET['id']);
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('cwf_range');
        $data['cat_data'] = (array) $db->where('cwf_rng_active','A')->where('cwf_rng_hash', $token)->get()->getRow();


        $db = \Config\Database::connect()->table('cwf_collections');
        $data['col_list'] = $db->where('cwf_coll_active','A')->where('cwf_coll_status','A')->orderby('cwf_coll_order', 'ASC')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/range/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_range');
        $save_data = array(
                            'cwf_rng_name'=> $data['title'],
                            'cwf_rng_slug'=> $data['slug'],
                            'cwf_rng_description'=> $data['description'],
                            'cwf_rng_status' => $data['status'],
                            'cwf_rng_coll_id' => $data['parent_category'],
                            'cwf_rng_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_rng_updated_id' => dsession_id(),
                            'cwf_rng_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('cwf_rng_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url().'?id='.$_GET['id']);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?id='.$_GET['id']);
        }

    }

}

