<?php 
$uri = current_url(true); 
$sub_title = ucwords(str_replace('-',' ', $uri->getSegment(2)));

?>

<form action="<?= current_url().'?action=edit&token='.$_GET['token']; ?>" id='update_form' method="post">

<div class="row bg-light p-3">
	<div class="col-md-12 mb-3">
		<a href="<?= base_url($uri->getSegment(1).'/'.$uri->getSegment(2)) ?>" class="float-end btn btn-primary rounded-0 btn-sm"><?php echo $sub_title; ?> List</a>
	</div>
	<div class="col-md-12 py-3">
		<div class="file-upload px-2">
			<div class="image-upload-wrap">
				<input class="file-upload-input" id="file" name="file" type='file' onchange="readURL(this);" accept="image/*" required />
				<div class="drag-text">
					<h3>Drag and drop a file or select add Image</h3>
				</div>
			</div>
			<div class="file-upload-content">
				<img class="file-upload-image" src="#" alt="your image" />
				<div class="image-title-wrap">
					<button type="button" onclick="removeUpload()" class="remove-image">Remove <span class="image-title">Uploaded Image</span></button>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Title<sup class="text-danger">*</sup></label>
		<input type="text" value="<?= $data['is_title']; ?>" name="title" required class="form-control rounded-0" >
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Sub Title<sup class="text-danger">*</sup></label>
		<input type="text"  value="<?= $data['is_sub_title']; ?>" name="sub_title" required class="form-control rounded-0">
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Link Text<sup class="text-danger">*</sup></label>
		<input type="text"  value="<?= $data['is_link_text']; ?>" name="link_text" required class="form-control rounded-0">
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Link<sup class="text-danger">*</sup></label>
		<input type="text"  value="<?= $data['is_link']; ?>" name="link" required class="form-control rounded-0">
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Alt<sup class="text-danger">*</sup></label>
		<input type="text"  value="<?= $data['is_img_alt']; ?>" name="alt" required class="form-control rounded-0">
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Status</label>
		<select name="status" id="" required class="form-select rounded-0">
			<?php 
			if($data['is_status'] == 'P')
			{
				echo '<option value="P" selected>Publish</option>
					  <option value="D">Draft</option>';
			}elseif($data['is_status'] == 'D')
			{
				echo '<option value="P">Publish</option>
					  <option value="D" selected>Draft</option>';
			}else
			{
				echo '<option value="P">Publish</option>
					  <option value="D">Draft</option>';
			}
			 ?>
		</select>
	</div>
	<div class="col-md-12">
		<button type="submit" class="btn btn-success rounded-0 btn-sm" id="update_btn">Update</button>
	</div>
</div>

</form>



<!-- Form Submit  -->
<script>
	var form = document.getElementById("update_form");
	$('#update_btn').click(function(){
		 form.submit();
		});
</script>



<script>

<?php  if(!empty($data['is_img_src'])){ ?>

$('.image-upload-wrap').hide();
const db_img = '<?= site_url('uploads/media/slider/'.$data['is_img_src']); ?>';
$('.file-upload-image').attr('src', db_img);
$('.file-upload-content').show();

<?php } ?>


function readURL(input) {
  if (input.files && input.files[0]) {

    var reader = new FileReader();

    reader.onload = function(e) {
      $('.image-upload-wrap').hide();
      $('.file-upload-image').attr('src', e.target.result);
      $('.file-upload-content').show();

      $('.image-title').html(input.files[0].name);

      	var form_data = new FormData();
      	form_data.append("file", document.getElementById('file').files[0]);

      	const token = '<?= $_GET['token']; ?>'
        $.ajax({
            method:'POST',
            url: '<?= site_url('ajax/upload/image/slider_image?token='); ?>' + token,
            data:form_data,
            contentType: false,
		    cache: false,
		    processData: false,
            success:function(data){
                console.log(data);
            },
            error: function(data){
                console.log("error");
                console.log(data);
            }
        });

    };

    reader.readAsDataURL(input.files[0]);

  } else {
    removeUpload();
  }
}

function removeUpload() {
  $('.file-upload-input').replaceWith($('.file-upload-input').clone());
  $('.file-upload-content').hide();
  $('.image-upload-wrap').show();
}
$('.image-upload-wrap').bind('dragover', function () {
    $('.image-upload-wrap').addClass('image-dropping');
  });
  $('.image-upload-wrap').bind('dragleave', function () {
    $('.image-upload-wrap').removeClass('image-dropping');
});

</script>
