<?php 
$uri = current_url(true); 
$sub_title = ucwords(str_replace('-',' ', $uri->getSegment(2)));

?>

<script src="https://cdn.ckeditor.com/4.19.0/standard/ckeditor.js"></script>


<div class="row">
	<div class="col-md-12">
		<ul class="nav nav-tabs">
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  href="<?= current_url().'?action=edit&token='.getProductHash($_GET['product_id']).'&product_id='.$_GET['product_id']; ?>">Basic</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  href="<?= current_url().'?action=edit&section=features&product_id='.$_GET['product_id']; ?>">Features</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  href="<?= current_url().'?action=edit&section=dimensions&product_id='.$_GET['product_id']; ?>">Dimensions</a>
		  </li>
		  
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=technical-information&product_id='.$_GET['product_id']; ?>">Technical Information</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=color&product_id='.$_GET['product_id']; ?>">Color</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=images&product_id='.$_GET['product_id']; ?>">Images</a>
		  </li>
		  <li class="nav-item">
		  	<a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=filters&product_id='.$_GET['product_id']; ?>">Filters</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=variant&product_id='.$_GET['product_id']; ?>">Variant</a>
		  </li>
		  <li class="nav-item">
		  	<a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=sku&product_id='.$_GET['product_id']; ?>">SKU</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=price&product_id='.$_GET['product_id']; ?>">Price</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=seo&product_id='.$_GET['product_id']; ?>">SEO</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 active"  href="<?= current_url().'?action=edit&section=accessories&product_id='.$_GET['product_id']; ?>">Accessories</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0 "  href="<?= current_url().'?action=edit&section=other&product_id='.$_GET['product_id']; ?>">Other</a>
		  </li>
		  <li class="nav-item">
		    <a class="nav-link rounded-0"  href="<?= current_url().'?action=edit&section=status&product_id='.$_GET['product_id']; ?>">Status</a>
		  </li>
		  
		</ul>
	</div>
</div>

<div class="row bg-light p-3">
	<div class="col-md-12 mb-3">
		<h3 class="fs-5 float-start">Manage Accessories</h3>

		
	</div>

	<div class="col-md-12">
		<form action="<?= current_url().'?action=edit&section='.$_GET['section'].'&product_id='.$_GET['product_id'].'&type=add' ?>" method="post">
			<div class="row">

	        	<div class="col-md-6 mb-3">
	        		<label class="form-label ">Accessories Sub Category</label>
	        		<select class="form-select " id="cat_select" name="sub_category" required>
	        			<option value="">Select</option>
	        			<?php 
						
						foreach($cat_list as $c){

							echo '<option value="'.$c->cwf_cat_id.'">'.$c->cwf_cat_name.'</option>';
						} 
						?>
	        		</select>
	        	</div>
	        	<div class="col-md-6 mb-3" >
	        		<label class="form-label ">Products</label>

	        		<div id="sub_category">
	        			<select class="form-select" name="product" required>
	        			</select>
	        		</div>
	        	</div>
	        	<div class="col-md-12">
	        		<label class="form-label">SKU</label>
	        		<select class="form-select rounded-0" multiple required name="sku_list[]">
	        			<?php foreach($sku_list as $l){  ?>
	        				<option value="<?= $l->cwf_psku_id ?>"><?= $l->cwf_psku_code ?> (<?= $l->cwfc_name; ?>)</option>
	        			<?php } ?>
	        		</select>
	        	</div>
	        	<div class="col-md-12 pt-4">
	        		<button type="submit" class="btn mt-1 btn-sm px-4 rounded-0 btn-success">Add</button>
	        	</div>

	        </div>
        </form>
	</div>




	<table class="table table-bordered">
		<thead>
			<tr>
				<th width="40">#</th>
				<th width="300">Product Title</th>
				<th>SKU</th>
				<th width="50">Short</th>
				<th width="70">Status</th>
				<th width="60">Action</th>
				<th width="40">Logs</th>
			</tr>
		</thead>
		<tbody>

			<?php $i=1; foreach($list as $l){ ?>

			<tr>
				<td><?= $i; ?> </td>
				<td><?= $l->pro_title; ?></td>
				<td>
					
					<?php 
					// print_r(getProductSkuDataByIds($l->cwfpa_sku_ids));
					foreach(getProductSkuDataByIds($l->cwfpa_sku_ids) as $lst)
					{
						echo $lst->cwf_psku_code.' ('.$lst->cwfc_name.') <br> ';
					}


					 ?>

				</td>
				<td>
					<input type="text" min="0" value="<?= $l->cwfpa_order; ?>" class="rounded-0 form-control order_input" id='<?= $l->cwfpa_hash; ?>' data-item-id='<?= $l->cwfpa_hash; ?>' >
				</td>
				<td class="pt-3">
					<?php 
									if($l->cwfpa_status == 'A')
									{
										echo '<span class="bg-success py-1 px-2 text-white rounded">Active</span>';
									}elseif($l->cwfpa_status == 'D')
									{
										echo '<span class="bg-danger py-1 px-2 text-white rounded">Deactive</span>';
									}
									 ?>
				</td>
				<td><a href="<?= current_url().'?action=editconf&section='.$_GET['section'].'&product_id='.$_GET['product_id'].'&token='.$l->cwfpa_hash; ?>" class="btn btn-sm btn-warning"><i class="bi bi-pencil-square"></i></a>
						<a href="<?= site_url('admin/delete?action='.$_GET['section'].'&token='.$l->cwfpa_hash.'&rid='.$_GET['product_id']); ?>" class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></a></td>
				<td>
					<?php logs($l->cwfpa_created_at, $l->cwfpa_created_id, $l->cwfpa_updated_at, $l->cwfpa_updated_id); ?>
				</td>
			</tr>

			<?php $i++; } ?>

		</tbody>
	</table>


</div>


<script>
    CKEDITOR.replace( 'editor' );
</script>


<script>
	
$(document).ready(function(){
	$('.order_input').keyup(function(){
		const token = $(this).data('item-id');
		var order_input = $(this).val();


		if(order_input <  1)
		{
			order_input = 1;
		}else
		{
			$.ajax({
				url:'<?= base_url('ajax/update/ordering?token=') ?>'+token+'&order='+order_input+'&action=product_accessories',
				type:'GET',
				success:function(data)
				{
					const resOBJ = JSON.parse(data);
					console.warn(resOBJ);
				},
				error:function()
				{
					alert('Ajax error');
				}
			});
		}

	});	
});

</script>
<script type="text/javascript">
	$(document).ready(function(){
		$('#cat_select').change(function(){
			const catId = $(this).val();

			$.ajax({
				url:'<?= site_url('ajax/get/product?cat_id=') ?>'+catId,
				method:'GET',
				success:function(data)
				{
					$('#sub_category').html(data);
				},error:function()
				{
					console.log('ajax error');
				}
			});

		});
	});
</script>